/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.accounts.impl;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.accounts.impl.accounts.http.RemoteHttpAccountObject;
import org.asf.edge.common.services.accounts.impl.accounts.http.RemoteHttpSaveContainer;
import org.asf.edge.common.tokens.TokenParseResult;
import org.asf.edge.common.util.HttpUpgradeUtil;
import org.asf.edge.common.util.SimpleBinaryMessageClient;

public class RemoteHttpAccountManager
extends AccountManager {
    private String urlBase = "http://127.0.0.1:5324/accountmanager/";
    private Logger logger = LogManager.getLogger((String)"AccountManager");

    @Override
    public void initService() {
    }

    @Override
    public void loadManager() {
        File configFile = new File("accountmanager.json");
        JsonObject accountManagerConfig = new JsonObject();
        if (configFile.exists()) {
            try {
                accountManagerConfig = JsonParser.parseString((String)Files.readString(configFile.toPath())).getAsJsonObject();
            }
            catch (JsonSyntaxException | IOException e) {
                this.logger.error("Failed to load account manager configuration!", e);
                return;
            }
        }
        JsonObject config = new JsonObject();
        if (!accountManagerConfig.has("remoteHttpManager")) {
            config.addProperty("url", this.urlBase);
            accountManagerConfig.add("remoteHttpManager", (JsonElement)config);
            try {
                Files.writeString(configFile.toPath(), (CharSequence)new Gson().newBuilder().setPrettyPrinting().create().toJson((JsonElement)accountManagerConfig), new OpenOption[0]);
            }
            catch (IOException e) {
                this.logger.error("Failed to write the account manager configuration!", (Throwable)e);
                return;
            }
        } else {
            config = accountManagerConfig.get("remoteHttpManager").getAsJsonObject();
        }
        this.urlBase = config.get("url").getAsString();
        if (!this.urlBase.endsWith("/")) {
            this.urlBase = this.urlBase + "/";
        }
        this.logger.info("Using remote account manager server, url: " + this.urlBase);
        this.logger.warn("Warning: the http-based remote account manager service is not efficient!");
        this.logger.warn("Warning: its highly recommened to use a different implementation, such as a database server.");
    }

    public JsonObject accountManagerRequest(String function, JsonObject payload) throws IOException {
        Object url = this.urlBase;
        url = (String)url + function;
        HttpURLConnection conn = (HttpURLConnection)new URL((String)url).openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.getOutputStream().write(payload.toString().getBytes("UTF-8"));
        if (conn.getResponseCode() != 200) {
            throw new IOException("Server returned HTTP " + conn.getResponseCode() + " " + conn.getResponseMessage());
        }
        try {
            return JsonParser.parseString((String)new String(conn.getInputStream().readAllBytes(), "UTF-8")).getAsJsonObject();
        }
        catch (Exception e) {
            throw new IOException("Server returned a non-json response");
        }
    }

    public Socket accountManagerUpgradeRequest(String function, JsonObject payload, String upgradeProtocol, String expectedResponseProtocol) throws IOException {
        Object url = this.urlBase;
        url = (String)url + function;
        byte[] body = payload.toString().getBytes("UTF-8");
        return HttpUpgradeUtil.upgradeRequest((String)url, "POST", new ByteArrayInputStream(body), body.length, Map.of("X-Request-ID", UUID.randomUUID().toString()), new HashMap<String, String>(), upgradeProtocol, expectedResponseProtocol);
    }

    @Override
    public boolean isValidUsername(String username) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("username", username);
            JsonObject response = this.accountManagerRequest("isValidUsername", payload);
            return response.get("result").getAsBoolean();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in isValidUsername!", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isValidPassword(String password) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("password", password);
            JsonObject response = this.accountManagerRequest("isValidPassword", payload);
            return response.get("result").getAsBoolean();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in isValidUsername!", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isUsernameTaken(String username) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("username", username);
            JsonObject response = this.accountManagerRequest("isUsernameTaken", payload);
            return response.get("result").getAsBoolean();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in isUsernameTaken!", (Throwable)e);
            return false;
        }
    }

    @Override
    public String getAccountID(String username) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("username", username);
            JsonObject response = this.accountManagerRequest("getAccountID", payload);
            if (!response.get("success").getAsBoolean()) {
                return null;
            }
            return response.get("id").getAsString();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getAccountID!", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getAccountIdBySaveUsername(String username) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("username", username);
            JsonObject response = this.accountManagerRequest("getAccountIdBySaveUsername", payload);
            if (!response.get("success").getAsBoolean()) {
                return null;
            }
            return response.get("id").getAsString();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getAccountID!", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean verifyPassword(String id, String password) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", id);
            payload.addProperty("password", password);
            JsonObject response = this.accountManagerRequest("verifyPassword", payload);
            return response.get("result").getAsBoolean();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in isValidUsername!", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean accountExists(String id) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", id);
            JsonObject response = this.accountManagerRequest("accountExists", payload);
            return response.get("result").getAsBoolean();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in accountExists!", (Throwable)e);
            return false;
        }
    }

    @Override
    public AccountObject getAccount(String id) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", id);
            JsonObject response = this.accountManagerRequest("getAccount", payload);
            if (!response.get("success").getAsBoolean()) {
                return null;
            }
            return new RemoteHttpAccountObject(id, response.get("username").getAsString(), this);
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getAccount!", (Throwable)e);
            return null;
        }
    }

    @Override
    public AccountObject getGuestAccount(String guestID) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("guestID", guestID);
            JsonObject response = this.accountManagerRequest("getGuestAccount", payload);
            if (!response.get("success").getAsBoolean()) {
                return null;
            }
            return new RemoteHttpAccountObject(response.get("id").getAsString(), response.get("username").getAsString(), this);
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getGuestAccount!", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getAccountIDByEmail(String email) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("email", email);
            JsonObject response = this.accountManagerRequest("getAccountIDByEmail", payload);
            if (!response.get("success").getAsBoolean()) {
                return null;
            }
            return response.get("id").getAsString();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getAccountIDByEmail!", (Throwable)e);
            return null;
        }
    }

    @Override
    public TokenParseResult verifyToken(String token) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("token", token);
            JsonObject response = this.accountManagerRequest("verifyToken", payload);
            return TokenParseResult.values()[response.get("result").getAsInt()];
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in verifyToken!", (Throwable)e);
            return null;
        }
    }

    @Override
    public byte[] signToken(String token) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("token", token);
            JsonObject response = this.accountManagerRequest("signToken", payload);
            return Base64.getDecoder().decode(response.get("result").getAsString());
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in signToken!", (Throwable)e);
            return null;
        }
    }

    @Override
    public AccountObject registerGuestAccount(String guestID) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("guestID", guestID);
            JsonObject response = this.accountManagerRequest("registerGuestAccount", payload);
            if (!response.get("success").getAsBoolean()) {
                return null;
            }
            return new RemoteHttpAccountObject(response.get("id").getAsString(), response.get("username").getAsString(), this);
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in registerGuestAccount!", (Throwable)e);
            return null;
        }
    }

    @Override
    public AccountObject registerAccount(String username, String email, char[] password) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("username", username);
            payload.addProperty("email", email);
            payload.addProperty("password", new String(password));
            JsonObject response = this.accountManagerRequest("registerAccount", payload);
            if (!response.get("success").getAsBoolean()) {
                return null;
            }
            return new RemoteHttpAccountObject(response.get("id").getAsString(), response.get("username").getAsString(), this);
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in registerAccount!", (Throwable)e);
            return null;
        }
    }

    @Override
    public AccountSaveContainer getSaveByID(String id) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("save", id);
            JsonObject response = this.accountManagerRequest("getSaveByID", payload);
            if (!response.get("success").getAsBoolean()) {
                return null;
            }
            return new RemoteHttpSaveContainer(id, response.get("time").getAsLong(), response.get("username").getAsString(), response.get("accid").getAsString(), this, this.getAccount(response.get("accid").getAsString()));
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getSaveByID!", (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] getOnlinePlayerIDs() {
        try {
            JsonObject payload = new JsonObject();
            JsonObject response = this.accountManagerRequest("getOnlinePlayerIDs", payload);
            JsonArray arr = response.get("players").getAsJsonArray();
            String[] saves = new String[arr.size()];
            int i = 0;
            for (JsonElement ele : arr) {
                saves[i++] = ele.getAsString();
            }
            return saves;
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getOnlinePlayerIDs!", (Throwable)e);
            return new String[0];
        }
    }

    @Override
    public void runForAllAccounts(Function<AccountObject, Boolean> func) {
        try {
            Object url = this.urlBase;
            url = (String)url + "runForAllAccounts";
            Socket conn = HttpUpgradeUtil.upgradeRequest((String)url, "POST", null, -1L, Map.of("X-Request-ID", UUID.randomUUID().toString()), new HashMap<String, String>(), "EDGEBINPROT/ACCMANAGER/RUNFORALLACCOUNTS", "EDGEBINPROT/ACCMANAGER/RUNFORALLACCOUNTS");
            SimpleBinaryMessageClient binH = new SimpleBinaryMessageClient((packet, client) -> {
                try {
                    String id = new String(packet.data, "UTF-8");
                    boolean res = (Boolean)func.apply(this.getAccount(id));
                    client.send(new byte[]{res ? (byte)1 : (byte)0});
                    if (!res) {
                        return false;
                    }
                }
                catch (Exception e) {
                    this.logger.error("Exception occurred while running runForAllAccounts!", (Throwable)e);
                    return false;
                }
                return true;
            }, conn.getInputStream(), conn.getOutputStream());
            binH.start();
            conn.close();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occured in runForAllAccounts!", (Throwable)e);
        }
    }
}

